library(readr)
library(ggplot2)
library(stargazer)
library(lme4)
library(MuMIn)
library(lmerTest)
library(rms)
library(sjstats)
library(ggpubr)
library(effsize)

stat.tests <- function(before, after) {
  w <- wilcox.test(unlist(before), unlist(after))
  es = cliff.delta(unlist(before), unlist(after), return.dm = TRUE)
  
  results <- c(w$p.value, w$p.value <= 0.05, es$estimate, es$magnitude, median(before), median(after))
  # 
  return(results)
}


# Importing dataset
data_25 <- read_csv("data_case_study.csv")
data_25$month_index <- rep((-12:12), 2)
data_25$month_index <- factor(data_25$month_index, levels=c((-12:12)),ordered=TRUE)

data <- data_25[-c(13, 38), ]
data['index'] <- lapply(data['index'] , factor)

#JuliaLang/julia
#cakephp/cakephp
newdata <- subset(data, (name == "cakephp/cakephp"))
data = newdata

before <- data[data$intervention == FALSE,]
after <- data[data$intervention == TRUE,]


# -----------------------------PRs------------------------------------

merged <- stat.tests(before$merged, after$merged)
nonmerged <- stat.tests(before$nonmerged, after$nonmerged)

g1 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$merged), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  #scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
  #              labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Num. of merged PRs", x="Month index") 


g2 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$nonmerged), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  #scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
  #              labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Num. of non-merged PRs", x="Month index")

ggarrange(g1, g2, nrow = 2, ncol = 1, common.legend = TRUE, legend="bottom")

ggsave("PRs.pdf", width = 4, height = 3, dpi = 300)

# -----------------------------COMMENTS------------------------------------

merged_comments <- stat.tests(before$comments_merged, after$comments_merged)
nonmerged_comments <- stat.tests(before$comments_nonmerged, after$comments_nonmerged)

g1 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$comments_merged), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  #scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
  #              labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  ylim(c(0, 5)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Median comments \n(merged PRs)", x="Month index") 

g2 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$comments_nonmerged), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  #scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
  #              labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  ylim(c(0, 15)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Median comments \n(non-merged PRs)", x="Month index")

ggarrange(g1, g2, nrow = 2, ncol = 1, common.legend = TRUE, legend="bottom")

ggsave("comments.pdf", width = 4, height = 3, dpi = 300)

# -----------------------------LATENCY------------------------------------
before$close_time_merged = before$close_time_merged/60
after$close_time_nonmerged = after$close_time_nonmerged/60

merged_time <- stat.tests(before$close_time_merged, after$close_time_merged)
nonmerged_time <- stat.tests(before$close_time_nonmerged, after$close_time_nonmerged)

g1 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$close_time_merged+1), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
                labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Median time to merge PRs \n(hours)", x="Month index")

g2 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$close_time_nonmerged+1), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
                labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Median time to reject PRs \n(hours)", x="Month index")

ggarrange(g1, g2, nrow = 2, ncol = 1, common.legend = TRUE, legend="bottom")

ggsave("time.pdf", width = 4, height = 3, dpi = 300)


# -----------------------------COMMITS------------------------------------

merged_commits <- stat.tests(before$commits_merged, after$commits_merged)
nonmerged_commits <- stat.tests(before$commits_nonmerged, after$commits_nonmerged)

g1 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$commits_merged), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  #scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
  #              labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  ylim(c(1, 4)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Median of commits \n(merged PRs)", x="Month index")

g2 <- ggplot(data_25, aes(data_25$month_index, as.numeric(data_25$commits_nonmerged), group=Project)) + 
  geom_line(aes(color = Project)) +
  geom_point(aes(color = Project)) +
  #scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x), 
  #              labels = scales::trans_format("log10", scales::math_format(10^.x))) +
  theme(text = element_text(size = 7)) +
  ylim(c(1, 4)) +
  scale_color_manual(values=c("#777777", "#5ab4ac")) +
  labs(y="Median of commits \n(non-merged PRs)", x="Month index")

ggarrange(g1, g2, nrow = 2, ncol = 1, common.legend = TRUE, legend="bottom")

ggsave("commits.pdf", width = 4, height = 3, dpi = 300)

